/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.automobile.attachment.front;

import io.github.foundationgames.automobility.automobile.attachment.FrontAttachmentType;
import io.github.foundationgames.automobility.automobile.attachment.front.FrontAttachment;
import io.github.foundationgames.automobility.entity.AutomobileEntity;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MobControllerFrontAttachment
extends FrontAttachment {
    public MobControllerFrontAttachment(FrontAttachmentType<?> type, AutomobileEntity automobile) {
        super(type, automobile);
    }

    @Override
    public boolean canDrive(Entity entity) {
        return super.canDrive(entity) || entity instanceof Mob;
    }

    @Override
    public boolean isProvidingAlternativeInputs(AutomobileEntity automobile, @Nullable Entity driver) {
        return automobile.isDriving(driver) && driver instanceof Mob;
    }

    @Override
    public void provideAlternativeInputs(AutomobileEntity auto, AutomobileEntity.Input input, @Nullable Entity e) {
        if (!(e instanceof Mob)) {
            return;
        }
        Mob driver = (Mob)e;
        if (driver.isDeadOrDying() || driver.isRemoved()) {
            if (input.setInputs(false, false, 0.0f, false, false)) {
                auto.markDirty();
            }
            return;
        }
        Path path = driver.getNavigation().getPath();
        if (path != null && !path.isDone() && path.getEndNode() != null) {
            float steer;
            Vec3 fnPos;
            double fnTarget;
            Vec3 pos = path.getEndNode().asVec3().subtract(auto.position());
            double target = Mth.wrapDegrees((double)Math.toDegrees(Math.atan2(pos.x(), pos.z())));
            if (Math.abs(target - (fnTarget = Mth.wrapDegrees((double)Math.toDegrees(Math.atan2((fnPos = path.getNextNode().asVec3().subtract(auto.position())).x(), fnPos.z()))))) > 69.0) {
                pos = fnPos;
                target = fnTarget;
            }
            float yaw = Mth.wrapDegrees((float)(-auto.getYRot()));
            double offset = Mth.wrapDegrees((double)((double)yaw - target));
            boolean reverse = false;
            float mul = 0.5f + Mth.clamp((float)auto.getHSpeed(), (float)0.0f, (float)1.0f) * 0.5f;
            if (pos.length() < (double)(20.0f * mul) && Math.abs(offset) > (double)(180.0f - 170.0f * mul)) {
                long time = auto.level().getGameTime();
                reverse = time % 80L <= 30L;
            }
            input.accelerating = !reverse;
            input.braking = reverse;
            float f = steer = reverse ? 1.0f : -1.0f;
            if (offset < -10.0) {
                input.steering = steer;
            } else if (offset > 10.0) {
                input.steering = -steer;
            }
            auto.markDirty();
        } else if (input.setInputs(false, false, 0.0f, false, false)) {
            auto.markDirty();
        }
    }
}

